﻿/*
 * [Function]
 * Emulate Baidu login using C# code, .NET 4.0, crifanLib.cs version
 * http://www.crifan.com/emulate_login_website_using_csharp/
 * 
 * [Author]
 * Crifan Li
 * 
 * [Date]
 * 2013-09-11
 * 
 * [Contact]
 * http://www.crifan.com/contact_me/
 * 
 * [Note]
 * 1.Crifan's C# Library
 * http://www.crifan.com/files/doc/docbook/crifanlib_csharp/release/html/crifanlib_csharp.html
 * 
 * 2.
 */

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.Net;
using System.IO;
using System.Text.RegularExpressions;
using System.Web;

using System.Globalization;

namespace emulateLoginBaidu
{
    public partial class frmEmulateLoginBaidu : Form
    {
        crifanLib crl;

        bool gotCookieBaiduid, extractTokenValueOK, loginBaiduOk;

        public frmEmulateLoginBaidu()
        {
            crl = new crifanLib();

            //crifanLib related init
            //set max enough to avoid http request is used out -> avoid dead while get response 
            System.Net.ServicePointManager.DefaultConnectionLimit = 200;
            
            InitializeComponent();
        }

        private void frmEmulateLoginBaidu_Load(object sender, EventArgs e)
        {
            this.AcceptButton = this.btnEmulateLoginBaidu;
            
            //init for demo login
            gotCookieBaiduid = false;
            extractTokenValueOK = false;
            loginBaiduOk = false;
        }


        /******************************************************************************
        Demo emulate login baidu related functions
        *******************************************************************************/

        private void btnGetBaiduid_Click(object sender, EventArgs e)
        {
            //http://www.baidu.com/
            string baiduMainUrl = txbBaiduMainUrl.Text;
            HttpWebResponse resp = crl.getUrlResponse(baiduMainUrl);
            CookieCollection currentCookies = crl.getCurCookies();
            txbGotBaiduid.Text = "";
            foreach (Cookie ck in currentCookies)
            {
                txbGotBaiduid.Text += "[" + ck.Name + "]=" + ck.Value + Environment.NewLine;
                if (ck.Name == "BAIDUID")
                {
                    gotCookieBaiduid = true;
                }
            }

            if (gotCookieBaiduid)
            {
                //already got andd store cookies before, inside _getUrlResponse
            }
            else 
            {
                MessageBox.Show("错误：没有找到cookie BAIDUID ！");
            }
        }

        private void btnGetToken_Click(object sender, EventArgs e)
        {
            if (gotCookieBaiduid)
            {
                string getapiUrl = "https://passport.baidu.com/v2/api/?getapi&class=login&tpl=mn&tangram=true";

                //https://passport.baidu.com/v2/api/?getapi&tpl=mn&apiver=v3&tt=1378868748011&class=login&logintype=dialogLogin&callback=bd__cbs__lm47sm
                //string getapiUrl = "https://passport.baidu.com/v2/api/?getapi&class=login&tpl=mn&apiver=v3";
                //string getapiUrl = "https://passport.baidu.com/v2/api/?getapi&class=login&tpl=mn&apiver=v3&logintype=dialogLogin";

                string respHtml = crl.getUrlRespHtml(getapiUrl);

                //bdPass.api.params.login_token='5ab690978812b0e7fbbe1bfc267b90b3';

                //when use .NET 4.0, return following html:

                //var bdPass=bdPass||{};
                //bdPass.api=bdPass.api||{};
                //bdPass.api.params=bdPass.api.params||{};
                //bdPass.api.params.login_token='the fisrt two args should be string type:0,1!';
                //    bdPass.api.params.login_tpl='mn';

                //            document.write('<script type="text/javascript" charset="UTF-8" src="https://passport.baidu.com/js/v2ApiUsedTangramFunctions.js?v=20130905"></script>');
                //        document.write('<script type="text/javascript" charset="UTF-8" src="https://passport.baidu.com/js/pass_api_login.js?v=20130905"></script>');

                string tokenValP = @"bdPass\.api\.params\.login_token='(?<tokenVal>\w+)';";
                Match foundTokenVal = (new Regex(tokenValP)).Match(respHtml);
                if (foundTokenVal.Success)
                {
                    //extracted the token value
                    txbExtractedTokenVal.Text = foundTokenVal.Groups["tokenVal"].Value;
                    extractTokenValueOK = true;
                }
                else
                {
                    txbExtractedTokenVal.Text = "错误：没有找到token的值！";
                }

            }
            else 
            {
                MessageBox.Show("错误：之前没有正确获得Cookie：BAIDUID ！");
            }
        }

        private void btnEmulateLoginBaidu_Click(object sender, EventArgs e)
        {
            if (gotCookieBaiduid && extractTokenValueOK)
            {
                string staticpage = "http://www.baidu.com/cache/user/html/jump.html";
                
                //init post dict info
                Dictionary<string, string> postDict = new Dictionary<string, string>();
                //postDict.Add("ppui_logintime", "");
                postDict.Add("charset", "utf-8");
                //postDict.Add("codestring", "");
                postDict.Add("token", txbExtractedTokenVal.Text);
                postDict.Add("isPhone", "false");
                postDict.Add("index", "0");
                //postDict.Add("u", "");
                //postDict.Add("safeflg", "0");
                postDict.Add("staticpage", staticpage);
                postDict.Add("loginType", "1");
                postDict.Add("tpl", "mn");
                postDict.Add("callback", "parent.bdPass.api.login._postCallback");
                postDict.Add("username", txbBaiduUsername.Text);
                postDict.Add("password", txbBaiduPassword.Text);
                //postDict.Add("verifycode", "");
                postDict.Add("mem_pass", "on");

                string baiduMainLoginUrl = "https://passport.baidu.com/v2/api/?login";
                string loginBaiduRespHtml = crl.getUrlRespHtml(baiduMainLoginUrl, postDict:postDict);

                //check whether got all expected cookies
                Dictionary<string, bool> cookieCheckDict = new Dictionary<string, bool>();
                string[] cookiesNameList = {"BDUSS", "PTOKEN", "STOKEN", "SAVEUSERID"};
                foreach (String cookieToCheck in cookiesNameList)
                {
                    cookieCheckDict.Add(cookieToCheck, false); 
                }

                CookieCollection currentCookies = crl.getCurCookies();
                foreach (Cookie singleCookie in currentCookies)
                {
                    if (cookieCheckDict.ContainsKey(singleCookie.Name))
                    {
                        cookieCheckDict[singleCookie.Name] = true;
                    }
                }

                bool allCookiesFound = true;
                foreach (bool foundCurCookie in cookieCheckDict.Values)
                {
                    allCookiesFound = allCookiesFound && foundCurCookie; 
                }


                loginBaiduOk = allCookiesFound;
                if (loginBaiduOk)
                {
                    txbEmulateLoginResult.Text = "成功模拟登陆百度首页！";
                }
                else
                {
                    txbEmulateLoginResult.Text = "模拟登陆百度首页 失败！";
                    txbEmulateLoginResult.Text += Environment.NewLine + "所返回的HTML源码为：";
                    txbEmulateLoginResult.Text += Environment.NewLine + loginBaiduRespHtml;
                }
            }
            else
            {
                MessageBox.Show("错误：没有正确获得Cookie BAIDUID 和/或 没有正确提取出token值！");
            }
        }

        private void lklEmulateLoginTutorialUrl_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            string emulateLoginTutorialUrl = "http://www.crifan.com/emulate_login_website_using_csharp";
            System.Diagnostics.Process.Start(emulateLoginTutorialUrl);
        }

        private void btnClearAll_Click(object sender, EventArgs e)
        {
            gotCookieBaiduid = false;
            extractTokenValueOK = false;
            loginBaiduOk = false;

            txbGotBaiduid.Text = "";
            txbExtractedTokenVal.Text = "";

            txbBaiduUsername.Text = "";
            txbBaiduPassword.Text = "";
            txbEmulateLoginResult.Text = "";
        }
    }
}
